﻿//////////////////////////////////////////////
// ByteAlignedClass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// Standards
#if defined(_MSC_VER)
	#include <malloc.h>
#else
	#include <cstdlib>
#endif

/// Class ------------------------------------
	
template<size_t alignment> class ByteAlignedClass
{		
	public :
		
		// Constructeur, destructeur
		ByteAlignedClass () {}
		~ByteAlignedClass () {}

		// Surcharges
		static void* operator new (size_t size)
		{
			#if defined(_MSC_VER)
				return _aligned_malloc(size, alignment) ;
			#elif defined(EMSCRIPTEN)
				return aligned_alloc(alignment, size) ;
			#else
				return std::aligned_alloc(alignment, size) ;
			#endif
		}

		static void* operator new[] (size_t size)
		{
			#if defined(_MSC_VER)
				return _aligned_malloc(size, alignment) ;
			#elif defined(EMSCRIPTEN)
				return aligned_alloc(alignment, size) ;
			#else
				return std::aligned_alloc(alignment, size) ;
			#endif
		}

		static void operator delete (void* memory)
		{
			#if defined(_MSC_VER)
				_aligned_free(memory) ;
			#elif defined(EMSCRIPTEN)
				free(memory) ;
			#else
				std::free(memory) ;
			#endif
		}

		static void operator delete[] (void* memory)
		{
			#if defined(_MSC_VER)
				_aligned_free(memory) ;
			#elif defined(EMSCRIPTEN)
				free(memory) ;
			#else
				std::free(memory) ;
			#endif
		}
} ;